<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Member extends Model 
{

    protected $table = 'members';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->hasMany('Attachment');
    }

    public function user()
    {
        return $this->hasOne('Job');
    }

    public function services()
    {
        return $this->hasMany('Service');
    }

}